package info.johannesgruber.jgnash.plugin.csvimport;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.swing.JMenuItem;
import javax.swing.JPanel;

import info.johannesgruber.jgnash.utils.ResourceUtils;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import jgnash.engine.message.Message;
import jgnash.engine.message.MessageBus;
import jgnash.engine.message.MessageChannel;
import jgnash.engine.message.MessageListener;
import jgnash.plugin.FxPlugin;
import jgnash.plugin.SwingPlugin;
import jgnash.uifx.views.main.MainView;

public class CsvImportPlugin implements SwingPlugin, FxPlugin {

	private static final Logger LOG = Logger.getLogger(CsvImportPlugin.class.getName());

	private static final int MENU_INDEX = 4;

	@Override
	public JMenuItem[] getMenuItems() {
		JMenuItem menuItem = new JMenuItem();

		menuItem.putClientProperty(SwingPlugin.PRECEDING_MENU_IDREF, "qifimport-command");

		LOG.info("Loading CsvImport plugin");

		try {
			menuItem.setAction(new ImportCsvAction());

			return new JMenuItem[] { menuItem };
		} catch (NoClassDefFoundError e) {
			Logger.getLogger(CsvImportPlugin.class.getName()).log(Level.SEVERE, e.getLocalizedMessage(), e);
			return null;
		}
	}

	@Override
	public String getName() {
		return "CSV Import Plugin";
	}

	@Override
	public JPanel getOptionsPanel() {
		return null;
	}

	@Override
	public void start(final PluginPlatform pluginPlatform) {
		if (pluginPlatform == PluginPlatform.Fx) {
			installFxMenu();
		}
	}

	@Override
	public void stop() {
	}


    private static void installFxMenu() {
        final MenuBar menuBar = MainView.getInstance().getMenuBar();

        menuBar.getMenus().stream().filter(menu -> "fileMenu".equals(menu.getId())).forEach(menu -> menu.getItems()
                .stream().filter(menuItem -> menuItem instanceof Menu)
                .filter(menuItem -> "importMenu".equals(menuItem.getId())).forEach(menuItem -> {

            final MenuItemEx importMenuItem = new MenuItemEx(ResourceUtils.getString("Menu.ImportCsv.Name"));

            importMenuItem.setOnAction(event -> ImportCsvFxAction.showAndWait());

            ((Menu) menuItem).getItems().add(2, importMenuItem);
        }));
    }
    
    private static class MenuItemEx extends MenuItem implements MessageListener {

        MenuItemEx(final String text) {
            super(text);
            MessageBus.getInstance().registerListener(this, MessageChannel.SYSTEM);
            disableProperty().setValue(true);
        }

        @Override
        public void messagePosted(final Message message) {
            Platform.runLater(() -> {
                switch (message.getEvent()) {
                    case FILE_LOAD_SUCCESS:
                        disableProperty().setValue(false);
                        break;
                    case FILE_CLOSING:
                        disableProperty().setValue(true);
                        break;
                    default:
                        break;
                }
            });
        }
}    

}
