/*
 * Decompiled with CFR 0.152.
 */
package info.johannesgruber.jgnash.plugin.csvimport;

import info.johannesgruber.jgnash.plugin.csvimport.CsvFile;
import info.johannesgruber.jgnash.plugin.csvimport.CsvImporter;
import info.johannesgruber.jgnash.plugin.csvimport.parser.CsvParser;
import info.johannesgruber.jgnash.utils.ResourceUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.SwingWorker;
import jgnash.convert.imports.GenericImport;
import jgnash.convert.imports.ImportBank;
import jgnash.engine.Account;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.ui.StaticUIMethods;
import jgnash.ui.UIApplication;
import jgnash.ui.actions.AbstractEnabledAction;
import jgnash.ui.wizards.imports.ImportDialog;

public class ImportCsvAction
extends AbstractEnabledAction {
    private static final long serialVersionUID = -229378377538399612L;
    private static final Logger LOG = Logger.getLogger(ImportCsvAction.class.getName());

    public ImportCsvAction() {
        ResourceBundle rb = ResourceUtils.getBundle();
        this.putValue("Name", rb.getString("Menu.ImportCsv.Name"));
        this.putValue("ShortDescription", rb.getString("Menu.ImportCsv.Tooltip"));
    }

    public void actionPerformed(ActionEvent e) {
        File file;
        ResourceBundle rb = ResourceUtils.getBundle();
        Engine engine = EngineFactory.getEngine((String)"default");
        if (engine == null || engine.getRootAccount().getChildCount() == 0) {
            StaticUIMethods.displayError((String)rb.getString("Message.Error.CreateBasicAccounts"));
            return;
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        try {
            chooser.setCurrentDirectory(new File(ImportCsvAction.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()));
        }
        catch (URISyntaxException e1) {
            LOG.warning("Could not set the directory correctly");
        }
        if (chooser.showOpenDialog((Component)UIApplication.getFrame()) == 0 && (file = chooser.getSelectedFile()).exists()) {
            new ImportCsv(file.getAbsolutePath()).execute();
        }
    }

    static final class ImportCsv
    extends SwingWorker<ImportBank, Void> {
        private final String fileName;

        ImportCsv(String fileName) {
            this.fileName = fileName;
        }

        @Override
        protected ImportBank doInBackground() throws Exception {
            CsvParser parser = new CsvParser();
            Throwable throwable = null;
            Object var3_4 = null;
            try (LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(this.fileName), StandardCharsets.ISO_8859_1));){
                CsvFile parsedFile = parser.parse(reader);
                return CsvImporter.convert(parsedFile);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        @Override
        protected void done() {
            try {
                ImportDialog d = new ImportDialog();
                ImportBank bank = (ImportBank)this.get();
                d.setSetting((Enum)ImportDialog.Settings.BANK, (Object)bank);
                d.setVisible(true);
                if (d.isWizardValid()) {
                    Account account = (Account)d.getSetting((Enum)ImportDialog.Settings.ACCOUNT);
                    List transactions = (List)d.getSetting((Enum)ImportDialog.Settings.TRANSACTIONS);
                    GenericImport.importTransactions((List)transactions, (Account)account);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

