#!/bin/bash

echo "`date +%H:%M:%S` Starting backup to USB hdd " | tee -a /var/log/rsync/backup_$(date +"%Y_%m_%d").log

echo "`date +%H:%M:%S` Copy <directory> to /tmp/misc... " | tee -a /var/log/rsync/backup_$(date +"%Y_%m_%d").log
cp -R <directory> /tmp/misc

echo "`date +%H:%M:%S` Pack /tmp/misc/<directory>... " | tee -a /var/log/rsync/backup_$(date +"%Y_%m_%d").log
tar -czvf /tmp/misc/<directory>.tar.gz /tmp/misc/<directory>
gpg --passphrase <passphrase> -c /tmp/misc/<directory>.tar.gz

echo "`date +%H:%M:%S` Backup data... " | tee -a /var/log/rsync/backup_$(date +"%Y_%m_%d").log
rsync -avu /tmp/misc/<directory>.tar.gz.gpg /run/media/<external hd>/backup 2>&1 | tee -a /var/log/rsync/backup_$(date +"%Y_%m_%d").log

rm -rf /tmp/misc/<directory>
rm -rf /tmp/misc/<directory>.tar.gz*

echo "`date +%H:%M:%S` Finished backup to USB hdd " | tee -a /var/log/rsync/backup_$(date +"%Y_%m_%d").log

