/*
 * Decompiled with CFR 0.152.
 */
package info.johannesgruber.jgnash.utils;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;

public class ResourceUtils {
    private static final String LOCALE = "locale";
    private static final String DEFAULT_RESOURCE_BUNDLE = "info.johannesgruber.jgnash.resources.resource";
    private static final String PREFERENCE_NODE = "/jgnash/util/Resource";
    private static ResourceBundle resourceBundle;

    static {
        Preferences p = Preferences.userRoot().node(PREFERENCE_NODE);
        Locale.setDefault(ResourceUtils.decodeLocale(p.get(LOCALE, "")));
    }

    private ResourceUtils() {
    }

    public static ResourceBundle getBundle() {
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle(DEFAULT_RESOURCE_BUNDLE);
            }
            catch (MissingResourceException e) {
                Logger.getLogger(ResourceUtils.class.getName()).log(Level.WARNING, "Could not find correct resource bundle", e);
                resourceBundle = ResourceBundle.getBundle(DEFAULT_RESOURCE_BUNDLE, Locale.ENGLISH);
            }
        }
        return resourceBundle;
    }

    public static String getString(String key, Object ... arguments) {
        try {
            if (arguments.length == 0) {
                return ResourceUtils.getBundle().getString(key);
            }
            return MessageFormat.format(ResourceUtils.getBundle().getString(key), arguments);
        }
        catch (MissingResourceException mre) {
            Logger.getLogger(ResourceUtils.class.getName()).log(Level.WARNING, "Missing resource for: " + key, mre);
            return key;
        }
    }

    public static void setLocale(Locale l) {
        Locale.setDefault(l);
        Preferences p = Preferences.userRoot().node(PREFERENCE_NODE);
        p.put(LOCALE, ResourceUtils.encodeLocale(l));
        resourceBundle = null;
    }

    private static String encodeLocale(Locale locale) {
        StringBuilder buf = new StringBuilder();
        buf.append(locale.getLanguage());
        if (!locale.getCountry().equals("")) {
            buf.append('.');
            buf.append(locale.getCountry());
            if (!locale.getVariant().equals("")) {
                buf.append('.');
                buf.append(locale.getVariant());
            }
        }
        return buf.toString();
    }

    private static Locale decodeLocale(String locale) {
        if (locale == null || locale.equals("") || locale.equals("null")) {
            return Locale.getDefault();
        }
        if (locale.indexOf(46) == -1) {
            return new Locale(locale);
        }
        Pattern LOCALE_DELIMITER_PATTERN = Pattern.compile("\\x2E");
        String[] array = LOCALE_DELIMITER_PATTERN.split(locale);
        if (array.length == 3) {
            return new Locale(array[0], array[1], array[2]);
        }
        if (array.length == 2) {
            return new Locale(array[0], array[1]);
        }
        return Locale.getDefault();
    }
}

