package info.johannesgruber.jgnash.utils;

import info.johannesgruber.jgnash.plugin.csvimport.parser.CsvParser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import jgnash.engine.Account;
import jgnash.engine.EngineFactory;

public class AccountUtils {
	
	private static AccountUtils instance;
	private Map<String, Account> accountMap;
	private static final Logger LOG = Logger.getLogger(CsvParser.class.getName());
	
	private AccountUtils() {
		init();
	}
	
	public static AccountUtils getInstance() {
		if (instance == null) {
			instance = new AccountUtils();
		}
		return instance;
	}
	
	public Account getAccountByNumber(String number) {
		return accountMap.get(number);
	}
	
	private void init() {
		accountMap = new HashMap<>();
		
		List<Account> accounts = EngineFactory.getEngine(EngineFactory.DEFAULT).getAccountList();
		for (Account a : accounts) {
			if (a.getAccountNumber() != null && !a.getAccountNumber().isEmpty())
			accountMap.put(a.getAccountNumber(), a);
		}
		
		LOG.info("Accounts=" + accountMap);

	}
}
