package info.johannesgruber.jgnash.plugin.csvimport;

import java.util.ArrayList;
import java.util.List;

import jgnash.convert.imports.ImportBank;
import jgnash.convert.imports.ImportTransaction;
import jgnash.convert.imports.ImportTransaction.ImportState;


public class CsvImporter {
	private CsvImporter() {
	}
	
	public static ImportBank convert(CsvFile file) {
		ImportBank retVal = new ImportBank();
		retVal.setTransactions(convertTransactions(file));
		return retVal;
	}
	
	private static List<ImportTransaction> convertTransactions(final CsvFile file) {
		List<ImportTransaction> retVal = new ArrayList<>();
		for (CsvRecord record : file.getRecords()) {
			retVal.add(CsvImporter.convert(record));
		}
		return retVal;
	}
	
	private static ImportTransaction convert(CsvRecord record) {
		ImportTransaction transaction = new ImportTransaction();
		transaction.setState(ImportState.NEW);
		transaction.amount = record.getAmount();
		transaction.datePosted = record.getBookingDate();
		transaction.memo = record.getMemo();
		transaction.account = record.getAccount();
		return transaction;
	}
}
