/*
 * Decompiled with CFR 0.152.
 */
package info.johannesgruber.jgnash.plugin.csvimport.parser;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import info.johannesgruber.jgnash.plugin.csvimport.CsvFile;
import info.johannesgruber.jgnash.plugin.csvimport.CsvRecord;
import info.johannesgruber.jgnash.utils.ResourceUtils;
import java.io.IOException;
import java.io.LineNumberReader;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class CsvParser {
    public static final String CSV_SEPARATOR = ";";
    private static final Logger LOG = Logger.getLogger(CsvParser.class.getName());
    public static final String KEY_DATE = "date";
    public static final String KEY_AMOUNT = "amount";
    public static final String KEY_MEMO = "memo";
    private Map<String, Integer> columns;

    public CsvFile parse(LineNumberReader reader) throws IOException, ParseException {
        CsvFile csvFile = new CsvFile();
        reader.mark(100000);
        String currentLine = reader.readLine();
        this.columns = this.getColumNames(currentLine, reader);
        currentLine = reader.readLine();
        while (currentLine != null) {
            csvFile.getRecords().add(this.parseRecord(currentLine));
            currentLine = reader.readLine();
        }
        return csvFile;
    }

    private CsvRecord parseRecord(String line) throws ParseException {
        List<String> lineParts = Splitter.on(CSV_SEPARATOR).trimResults(CharMatcher.anyOf("\"")).splitToList(line);
        CsvRecord rec = new CsvRecord();
        LOG.info("Line parts = " + lineParts);
        LOG.info("Date=" + lineParts.get(this.columns.get(KEY_DATE)) + ", amount=" + lineParts.get(this.columns.get(KEY_AMOUNT)) + ", memo=" + lineParts.get(this.columns.get(KEY_MEMO)));
        try {
            DateFormat df = DateFormat.getDateInstance(3, Locale.getDefault());
            rec.setBookingDate(df.parse(lineParts.get(this.columns.get(KEY_DATE))));
            Number amount = NumberFormat.getNumberInstance(Locale.getDefault()).parse(lineParts.get(this.columns.get(KEY_AMOUNT)));
            rec.setAmount(BigDecimal.valueOf(amount.doubleValue()));
        }
        catch (NumberFormatException nfe) {
            LOG.warning("Could not parse the amount [" + lineParts.get(this.columns.get(KEY_AMOUNT)) + "], set default value ZERO");
            rec.setAmount(BigDecimal.ZERO);
        }
        catch (ParseException pe) {
            LOG.warning("Could not parse the date [" + lineParts.get(this.columns.get(KEY_DATE)) + "], set default value");
            rec.setBookingDate(new Date());
        }
        rec.setMemo(lineParts.get(this.columns.get(KEY_MEMO)));
        return rec;
    }

    private Map<String, Integer> getColumNames(String headline, LineNumberReader reader) throws IOException {
        ResourceBundle rb = ResourceUtils.getBundle();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Iterable<String> columns = Splitter.on(CSV_SEPARATOR).trimResults().trimResults(CharMatcher.anyOf("\"")).split(headline);
        int i = 0;
        for (String col : columns) {
            if (col.equals(rb.getString("ImportCsv.Column.Date"))) {
                map.put(KEY_DATE, i);
            } else if (col.equals(rb.getString("ImportCsv.Column.Memo"))) {
                map.put(KEY_MEMO, i);
            } else if (col.equals(rb.getString("ImportCsv.Column.Amount"))) {
                map.put(KEY_AMOUNT, i);
            } else {
                LOG.fine("Column name [" + col + "] is not supported, ignore it");
            }
            ++i;
        }
        if (map.size() < 3) {
            LOG.info("The headline is not correct, use the default order of columns");
            map.put(KEY_DATE, 2);
            map.put(KEY_AMOUNT, 3);
            map.put(KEY_MEMO, 1);
            reader.reset();
        }
        return map;
    }
}

