#!/bin/bash

echo "`date +%H:%M:%S` Starting backup to NAS " | tee -a /var/log/rsync/backup_$(date +"%Y_%m_%d").log

if [ -d /var/log/rsync/ ] ; then
echo "`date +%H:%M:%S` Log directory /var/log/rsync already exists"
else
sudo mkdir /var/log/rsync
sudo chmod 774 /var/log/rsync
sudo chgrp /var/log/rsync <user>
echo "`date +%H:%M:%S` Created log directory /var/log/rsync"
fi

echo "`date +%H:%M:%S` Backup <directory>... " | tee -a /var/log/rsync/backup_$(date +"%Y_%m_%d").log
rsync -avu --exclude-from 'rsync_exclude.txt' -e '/usr/bin/ssh -i /home/<user>/.ssh/rsync-key' <directory> <user>@<ip adress of NAS>:/volume1/backup 2>&1 | tee -a /var/log/rsync/backup_$(date +"%Y_%m_%d").log

echo "`date +%H:%M:%S` Finished backup to NAS " | tee -a /var/log/rsync/backup_$(date +"%Y_%m_%d").log

