/*
 * Decompiled with CFR 0.152.
 */
package info.johannesgruber.jgnash.utils;

import info.johannesgruber.jgnash.plugin.csvimport.parser.CsvParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jgnash.engine.Account;
import jgnash.engine.EngineFactory;

public class AccountUtils {
    private static AccountUtils instance;
    private Map<String, Account> accountMap;
    private static final Logger LOG;

    static {
        LOG = Logger.getLogger(CsvParser.class.getName());
    }

    private AccountUtils() {
        this.init();
    }

    public static AccountUtils getInstance() {
        if (instance == null) {
            instance = new AccountUtils();
        }
        return instance;
    }

    public Account getAccountByNumber(String number) {
        return this.accountMap.get(number);
    }

    private void init() {
        this.accountMap = new HashMap<String, Account>();
        List accounts = EngineFactory.getEngine((String)"default").getAccountList();
        for (Account a : accounts) {
            if (a.getAccountNumber() == null || a.getAccountNumber().isEmpty()) continue;
            this.accountMap.put(a.getAccountNumber(), a);
        }
        LOG.info("Accounts=" + this.accountMap);
    }
}

