/*
 * Decompiled with CFR 0.152.
 */
package info.johannesgruber.jgnash.plugin.csvimport;

import info.johannesgruber.jgnash.plugin.csvimport.ImportCsvAction;
import info.johannesgruber.jgnash.plugin.csvimport.ImportCsvFxAction;
import info.johannesgruber.jgnash.utils.ResourceUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import jgnash.engine.message.Message;
import jgnash.engine.message.MessageBus;
import jgnash.engine.message.MessageChannel;
import jgnash.engine.message.MessageListener;
import jgnash.plugin.FxPlugin;
import jgnash.plugin.Plugin;
import jgnash.plugin.SwingPlugin;
import jgnash.uifx.views.main.MainView;

public class CsvImportPlugin
implements SwingPlugin,
FxPlugin {
    private static final Logger LOG = Logger.getLogger(CsvImportPlugin.class.getName());
    private static final int MENU_INDEX = 4;

    public JMenuItem[] getMenuItems() {
        JMenuItem menuItem = new JMenuItem();
        menuItem.putClientProperty("PrecedingMenuIdref", "qifimport-command");
        LOG.info("Loading CsvImport plugin");
        try {
            menuItem.setAction((Action)((Object)new ImportCsvAction()));
            return new JMenuItem[]{menuItem};
        }
        catch (NoClassDefFoundError e) {
            Logger.getLogger(CsvImportPlugin.class.getName()).log(Level.SEVERE, e.getLocalizedMessage(), e);
            return null;
        }
    }

    public String getName() {
        return "CSV Import Plugin";
    }

    public JPanel getOptionsPanel() {
        return null;
    }

    public void start(Plugin.PluginPlatform pluginPlatform) {
        if (pluginPlatform == Plugin.PluginPlatform.Fx) {
            CsvImportPlugin.installFxMenu();
        }
    }

    public void stop() {
    }

    private static void installFxMenu() {
        MenuBar menuBar = MainView.getInstance().getMenuBar();
        menuBar.getMenus().stream().filter(menu -> "fileMenu".equals(menu.getId())).forEach(menu -> menu.getItems().stream().filter(menuItem -> menuItem instanceof Menu).filter(menuItem -> "importMenu".equals(menuItem.getId())).forEach(menuItem -> {
            MenuItemEx importMenuItem = new MenuItemEx(ResourceUtils.getString("Menu.ImportCsv.Name", new Object[0]));
            importMenuItem.setOnAction(event -> ImportCsvFxAction.showAndWait());
            ((Menu)menuItem).getItems().add(2, (Object)importMenuItem);
        }));
    }

    private static class MenuItemEx
    extends MenuItem
    implements MessageListener {
        MenuItemEx(String text) {
            super(text);
            MessageBus.getInstance().registerListener((MessageListener)this, new MessageChannel[]{MessageChannel.SYSTEM});
            this.disableProperty().setValue(Boolean.valueOf(true));
        }

        public void messagePosted(Message message) {
            Platform.runLater(() -> {
                switch (message.getEvent()) {
                    case FILE_LOAD_SUCCESS: {
                        this.disableProperty().setValue(Boolean.valueOf(false));
                        break;
                    }
                    case FILE_CLOSING: {
                        this.disableProperty().setValue(Boolean.valueOf(true));
                        break;
                    }
                }
            });
        }
    }
}

