package info.johannesgruber.jgnash.plugin.csvimport;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;

import jgnash.convert.imports.ImportBank;
import jgnash.convert.imports.ImportState;
import jgnash.convert.imports.ImportTransaction;


public class CsvImporter {
	private CsvImporter() {
	}
	
	public static ImportBank<ImportTransaction> convert(CsvFile file) {
		ImportBank<ImportTransaction> retVal = new ImportBank<ImportTransaction>();
		retVal.setTransactions(convertTransactions(file));
		return retVal;
	}
	
	private static List<ImportTransaction> convertTransactions(final CsvFile file) {
		List<ImportTransaction> retVal = new ArrayList<>();
		for (CsvRecord record : file.getRecords()) {
			retVal.add(CsvImporter.convert(record));
		}
		return retVal;
	}
	
	private static ImportTransaction convert(CsvRecord record) {
		ImportTransaction transaction = new ImportTransaction();
		transaction.setState(ImportState.NEW);
		transaction.setAmount(record.getAmount());
		LocalDate date = record.getBookingDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
		transaction.setDatePosted(date);
		transaction.setMemo(record.getMemo());
		transaction.setAccount(record.getAccount());
		return transaction;
	}
}
